package de.mse.uebung7;

import org.junit.Test;

import java.util.HashMap;
import java.util.Random;

import static junit.framework.TestCase.assertEquals;

// NOTE: For running this code jUnit is required: https://github.com/junit-team/junit4/wiki/Download-and-Install
public class HashingChainingTest {

   @Test
   public void simpleTest() {
      HashingChaining<String, Integer> map = new HashingChaining<String, Integer>(16);
      map.put("ALL", 1);
      map.put("YOUR", 2);
      map.put("BASE", 3);
      map.put("ARE", 4);
      map.put("BELONG", 5);
      map.put("TO", 6);
      map.put("US", 7);

      assertEquals(6, (int) map.get("TO"));
      assertEquals(null, map.get("US_2"));
   }

   @Test
   public void randomizedTest() {
      HashingChaining<Integer, Integer> map = new HashingChaining<Integer, Integer>(1024);
      HashMap<Integer, Integer> reference = new HashMap<Integer, Integer>();
      Random random = new Random();

      for (int i = 0; i < 1000; i++) {
         switch (Math.abs(random.nextInt()) % 2) {
            case 0: { // Insert
               performInsert(map, reference, random);
               break;
            }
            case 1: { // Delete
               // performDelete(map, reference, random); TODO
               break;
            }
         }
      }
   }

   private void performInsert(HashingChaining<Integer, Integer> map, HashMap<Integer, Integer> reference, Random random) {
      // Generate a random numbers
      int key = random.nextInt();
      int value = random.nextInt();

      // Check
      assertEquals(reference.get(key), map.get(key));

      // Update
      map.put(key, value);
      reference.put(key, value);

      // Check again
      assertEquals(reference.get(key), map.get(key));
   }
}
